/**
 * 
 */
/**
 * @author Janet Lopez
 *
 */
package gov.va.genisis2Test.service.impl;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.service.impl.StudyApprovalService;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * The Class StudyApprovalServiceTest.
 *
 * @author1 Janet Lopez
 * @author Getaneh Kassahun
 * 
 *          The Class StudyApprovalServiceTest.
 * 
 *          Description: In this StudyApprovalServiceTest Class which extends
 *          the abstract class, AbstractMockMvcTests, junit tests are defined.
 */

public class StudyApprovalServiceTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(StudyApprovalServiceTest.class);

	@Test
	public void testStudyApprovalService() {

		logger.info("**********Junit Test Study Approval Service**********");
		StudyApprovalService studyApprovalService = new StudyApprovalService();
		assertNull(studyApprovalService.getStudyApprovalDao());
		studyApprovalService.setStudyApprovalDao(getMockStudyApprovalDao());
		StudyApproval studyApproval = Helper.getStudyApproval();
		getMockHibernateTemplate().save(studyApproval);

		int studyApprovalId = studyApprovalService.createStudyApproval(studyApproval);
		Assert.assertNotNull(studyApprovalId);
		studyApproval.setId(studyApprovalId);
		int studyApprovalIda = studyApprovalService.updateStudyApproval(studyApproval);
		Assert.assertEquals(studyApprovalId, studyApprovalIda);

		List<StudyApproval> studyApprovalA = studyApprovalService.getStudyApprovals();
		Assert.assertNotNull(studyApprovalA);
		StudyApproval studyApprovalI = studyApprovalService.getStudyApprovalsByID(1);
		// Assert.assertNotNull(studyApprovalI.getId());
		List<StudyApproval> studyApprovals = studyApprovalService.getStudyApprovalsByUID("createdBy");
		Assert.assertNotNull(studyApprovals);

		logger.info("**********End Junit Test Study Approval Service**********");

	}
}
